VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form Form1 
   Caption         =   "Keys to Remove"
   ClientHeight    =   6420
   ClientLeft      =   45
   ClientTop       =   525
   ClientWidth     =   9750
   LinkTopic       =   "Form1"
   ScaleHeight     =   6420
   ScaleWidth      =   9750
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdRestoreKeys 
      Caption         =   "Restore Keys"
      Height          =   375
      Left            =   7200
      TabIndex        =   8
      Top             =   1080
      Width           =   1815
   End
   Begin MSComDlg.CommonDialog CD1 
      Left            =   5760
      Top             =   120
      _ExtentX        =   688
      _ExtentY        =   688
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin VB.CommandButton cmdBackupKeys 
      Caption         =   "Backup keys"
      Height          =   372
      Left            =   5040
      TabIndex        =   7
      Top             =   1080
      Width           =   1935
   End
   Begin VB.CommandButton cmdDelTools 
      Caption         =   "Delete Selected Toolbar Data"
      Height          =   372
      Left            =   2280
      TabIndex        =   5
      Top             =   3600
      Width           =   2532
   End
   Begin VB.CommandButton cmdDelApps 
      Caption         =   "Delete Selected App Keys"
      Height          =   372
      Left            =   2160
      TabIndex        =   4
      Top             =   1080
      Width           =   2532
   End
   Begin VB.ListBox lboToolbarKeys 
      Height          =   2085
      ItemData        =   "frmRegScrub.frx":0000
      Left            =   240
      List            =   "frmRegScrub.frx":0002
      Style           =   1  'Checkbox
      TabIndex        =   2
      Top             =   4080
      Width           =   9255
   End
   Begin VB.ListBox lboAppKeys 
      Height          =   1860
      ItemData        =   "frmRegScrub.frx":0004
      Left            =   240
      List            =   "frmRegScrub.frx":0006
      Style           =   1  'Checkbox
      TabIndex        =   0
      Top             =   1560
      Width           =   9255
   End
   Begin VB.Label lblKeyNames 
      AutoSize        =   -1  'True
      Caption         =   "lblKeyNames"
      Height          =   192
      Left            =   240
      TabIndex        =   6
      Top             =   0
      Width           =   972
   End
   Begin VB.Label lblToolbars 
      AutoSize        =   -1  'True
      Caption         =   "Keys with Toolbar Data"
      Height          =   192
      Left            =   240
      TabIndex        =   3
      Top             =   3840
      Width           =   1656
   End
   Begin VB.Label lblAppKeys 
      AutoSize        =   -1  'True
      Caption         =   "Addin Application Keys"
      Height          =   195
      Left            =   240
      TabIndex        =   1
      Top             =   1320
      Width           =   1740
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public IDAddin As String 'addin CLSID
Dim IDKeyLib As String 'TypeLib CLSID
Dim KeyColl As New Collection 'keys to delete
Dim ToolColl As New Collection 'keys with toolbar data to delete
Dim lRet As Long
Dim AK As TargetKey
Public ToolBar As String
Dim KeyCodex As Scripting.Dictionary
Dim ConnName As String 'name of SW connection class

'used for folder browser API
Const BIF_RETURNONLYFSDIRS = 1
Const BIF_DONTGOBELOWDOMAIN = 2
Const MAX_PATH = 260


'used for folder browser API
Private Type BrowseInfo
   hwndOwner As Long
   pIDLRoot As Long
   pszDisplayName As Long
   lpszTitle As Long
   ulFlags  As Long
   lpfnCallback   As Long
   lParam   As Long
   iImage   As Long
End Type

Private Declare Function SHBrowseForFolder Lib "shell32" _
    (lpbi As BrowseInfo) As Long

Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" _
    (ByVal hwnd As Long, _
    ByVal lpOperation As String, _
    ByVal lpFile As String, _
    ByVal lpParameters As String, _
    ByVal lpDirectory As String, _
    ByVal nShowCmd As Long) _
    As Long


Private Sub cmdBackupKeys_Click()
Dim BackMessage As String
Dim FS As Scripting.FileSystemObject
Dim TS As Scripting.TextStream
Dim bLogFile As String
Dim bLogDir As String 'folder for log directory and all backup reg keys
Dim ReadKey As String
Dim bRoot As Long 'parsed root from list
Dim bKey As String 'parsed key from string
Dim ToolBarData As Long
Dim lRet As Long
Dim vRet As Variant
Dim bRet As Boolean
Dim I As Long

BackMessage = "Keys are backed up in multiple '.reg' files in the same folder as the '.txt' file you are about to create."
BackMessage = BackMessage & "  It is recommended that you create a new folder especially for these files to prevent overwriting any previous backups."
MsgBox BackMessage

On Error Resume Next
CD1.CancelError = True
CD1.Filter = "Text file (*.txt)|*.txt"
CD1.ShowSave
If Err = 32755 Then 'cancelled
    Exit Sub
Else
    bLogFile = CD1.FileName
    vRet = ParsePath(bLogFile, "\", 1)
    bLogDir = CStr(vRet(1))
End If

Set FS = CreateObject("Scripting.FileSystemObject")
Set TS = FS.CreateTextFile(bLogFile, True)

'write header
TS.WriteLine Now 'current date and time
TS.WriteLine lblKeyNames.Caption
If ConnName <> "" Then TS.WriteLine "SW connection class name: " & ConnName
TS.WriteBlankLines 1

'copy key names
TS.WriteLine "\\CLSID keys saved to binary files:"
For I = 0 To (lboAppKeys.ListCount - 1)
    ReadKey = lboAppKeys.List(I)
    vRet = ParsePath(ReadKey, "\", -1)
    bRoot = CLng(Val(KeyCodex(CStr(vRet(1)))))
    bKey = CStr(vRet(3))
    bRet = regSaveKey_to_file(bRoot, bKey, bLogDir & "\" & CStr(I))
    If bRet Then TS.WriteLine CStr(I) & "; " & ReadKey
Next
TS.Write "\\End of CLSID key information"

TS.WriteBlankLines 2

'write toolbar keys if specified
If ToolBar = "" Or lboToolbarKeys.ListCount <= 0 Then
    TS.WriteLine "No toolbar name specified."
    TS.Close
Else
    ToolBarData = 0
    TS.WriteLine "\\Keys with toolbars: " & ToolBar
    For I = 0 To lboToolbarKeys.ListCount - 1
        ReadKey = lboToolbarKeys.List(I)
        vRet = ParsePath(ReadKey, "\", -1)
        bRoot = CLng(Val(KeyCodex(CStr(vRet(1)))))
        bKey = CStr(vRet(3))
        
        'get toolbar key data
        On Error Resume Next
        ToolBarData = CLng(regQuery_A_Key(bRoot, bKey, ToolBar))
        '"binarify" ToolBarData
        If ToolBarData < 1 Or Err.Number <> 0 Then
            ToolBarData = 0
        Else
            ToolBarData = 1
        End If
        Err.Clear
        On Error GoTo 0
        
        TS.WriteLine ReadKey & vbTab & "value:" & CStr(ToolBarData)
        ToolBarData = 0
    Next
    TS.WriteLine "\\End of Toolbar information"
    TS.Close
End If

'close out objects
Set TS = Nothing
Set FS = Nothing

lRet = MsgBox("Would you like to view the log file?", vbYesNo, "")
If lRet = vbYes Then ShellExecute 0, vbNullString, bLogFile, vbNullString, "C:\", 1
End Sub

Private Sub cmdDelApps_Click()
Dim dProceed As VbMsgBoxResult
dProceed = MsgBox("Delete all selected keys?", vbYesNo, "Delete Keys")
If dProceed = vbNo Then Exit Sub
Dim I As Long
Dim lItem As String
Dim dRoot As Long
Dim dKey As String
Dim tVar As Variant
For I = 0 To (lboAppKeys.ListCount - 1)
    lItem = CStr(lboAppKeys.List(I))
    tVar = ParsePath(lItem, "\", -1)
    dRoot = CLng(KeyCodex(CStr(tVar(1))))
    dKey = CStr(tVar(3))
    If regDoes_Key_Exist(dRoot, dKey) Then _
        regDelete_Key_And_Subkeys dRoot, dKey
Next
End Sub

Private Sub cmdDelTools_Click()

If ToolBar = "" Then
    MsgBox "No Toolbar name selected."
    Exit Sub
End If

Dim dProceed As VbMsgBoxResult
dProceed = MsgBox("Delete selected toolbar registry data for toolbar '" & ToolBar & "'?", vbYesNo, "Delete Toolbar Data")
If dProceed = vbNo Then Exit Sub
Dim I As Long
Dim lItem As String
Dim dRoot As Long
Dim dKey As String
Dim tVar As Variant
For I = 0 To (lboToolbarKeys.ListCount - 1)
    lItem = CStr(lboToolbarKeys.List(I))
    tVar = ParsePath(lItem, "\", -1)
    dRoot = CLng(KeyCodex(CStr(tVar(1))))
    dKey = CStr(tVar(3))
    regDelete_Key_Value dRoot, dKey, ToolBar
Next
End Sub


Private Sub cmdRestoreKeys_Click()

Dim FS As Scripting.FileSystemObject
Dim TS As Scripting.TextStream
Dim bLogFile As String
Dim bLogDir As String 'folder for log directory and all backup reg keys
Dim sLine As String 'line in from TS
Dim iKey As String 'numerical file name of key to restore
Dim sRoot As String 'parsed root from string
Dim lRoot As Long 'key root value
Dim sKey As String 'parsed key from string
Dim ContFlag As Boolean 'continue flag
Dim RestoreKeyFile As String
Dim ResToolBar As String 'name of toolbar to restore
Dim ToolValue As String
Dim sToolData As String
Dim lToolData As Long
Dim lRet As Long
Dim vRet As Variant
Dim bRet As Boolean
Dim I As Long

On Error Resume Next
CD1.CancelError = True
CD1.Filter = "Text File (*.txt)|*.txt|All files (*.*)|*.*"
CD1.FilterIndex = 1
CD1.ShowOpen
If Err.Number = 32755 Then 'cancelled
Stop
    Exit Sub
Else
    bLogFile = CD1.FileName
    vRet = ParsePath(bLogFile, "\", 1)
    bLogDir = CStr(vRet(1))
End If
Stop

ContFlag = False
Set FS = CreateObject("Scripting.FileSystemObject")
Set TS = FS.OpenTextFile(bLogFile, ForReading)

Do While Not TS.AtEndOfStream
    sLine = TS.ReadLine
    If sLine = "\\CLSID keys saved to binary files:" Then
        ContFlag = True
        Exit Do
    End If
Loop
If Not ContFlag Then
    MsgBox "No valid key information found"
    Exit Sub
End If

ContFlag = True
Do While ContFlag
    sLine = TS.ReadLine
    If Left(sLine, 2) = "\\" Or TS.AtEndOfStream Then
        ContFlag = False
        Exit Do
    End If
    vRet = ParsePath(sLine, ";", -1)
    iKey = CStr(vRet(1))
    sKey = Trim(CStr(vRet(3)))
    vRet = ParsePath(sKey, "\", -1)
    sRoot = Trim(CStr(vRet(1)))
    lRoot = CLng(KeyCodex(sRoot))
    sKey = Trim(CStr(vRet(3)))
    If Not sKey = "" And Not sRoot = "" Then
        RestoreKeyFile = bLogDir & "\" & iKey
        If FS.FileExists(RestoreKeyFile) Then
            Stop
            bRet = regRestoreKey_from_file(lRoot, sKey, RestoreKeyFile)
        End If
    End If
Loop

'find toolbar info
ContFlag = True
Do While ContFlag
    sLine = TS.ReadLine
    If sLine = "No toolbar name specified." Then Stop: GoTo EndOfRestoreKeys
    If InStr(1, sLine, "\\Keys with toolbars:", vbTextCompare) = 1 Then
        ContFlag = False
        vRet = ParsePath(sLine, ":", -1)
        ResToolBar = Trim(CStr(vRet(3)))
        Exit Do
    End If
Loop
Stop

Do
    sLine = TS.ReadLine
    'end of data?
    If Left(sLine, 2) = "\\" Or TS.AtEndOfStream Then GoTo EndOfRestoreKeys
    
    'parse key from value
    vRet = ParsePath(sLine, vbTab, -1)
    sKey = Trim(CStr(vRet(1)))
    ToolValue = Trim(CStr(vRet(3)))
    'parse root from rest of key
    vRet = ParsePath(sKey, "\", -1)
    sRoot = Trim(CStr(vRet(1)))
    lRoot = CLng(KeyCodex(sRoot))
    sKey = Trim(CStr(vRet(3)))
    'parse toolbar data setting
    vRet = ParsePath(ToolValue, ":", 1)
    sToolData = Trim(CStr(vRet(3)))
    lToolData = CLng(sToolData)
    If Not sKey = "" And Not sRoot = "" Then
        regCreate_Key_Value lRoot, sKey, ResToolBar, lToolData, regForceDWORD
    End If
    Stop
Loop

EndOfRestoreKeys:
ShellExecute 0, vbNullString, bLogFile, vbNullString, "C:\", 1

End Sub

Private Sub Form_DblClick()
End
End Sub

Private Sub Form_Load()
frmInput.Show vbModal
Unload frmInput

PauseForXSeconds 0.1
frmLongTime.AutoRedraw = True
frmLongTime.Show
PauseForXSeconds 0.1
'hide this form at the end of GetTheyKeys

LoadKeyCodex
Me.AutoRedraw = True
'IDAddin = "{BC0FFEDC-F2D1-4DD8-8EFA-17F55E3864C3}"
'ToolBar = "Wojo"

GetTheKeys

End Sub
Sub GetTheKeys()
'1.) add SW Addin key
AddKeyToColl HKEY_LOCAL_MACHINE, ("SOFTWARE\SolidWorks\AddIns\" & IDAddin)

'2.) get TypeLib CLSID and add keys
If regDoes_Key_Exist(HKEY_CLASSES_ROOT, ("CLSID\" & IDAddin & "\TypeLib")) Then
    IDKeyLib = regQuery_A_Key(HKEY_CLASSES_ROOT, ("CLSID\" & IDAddin & "\TypeLib"), "")
ElseIf regDoes_Key_Exist(HKEY_LOCAL_MACHINE, ("SOFTWARE\Classes\CLSID\" & IDAddin & "\TypeLib")) Then
    IDKeyLib = regQuery_A_Key(HKEY_LOCAL_MACHINE, ("SOFTWARE\Classes\CLSID\" & IDAddin & "\TypeLib"), "")
Else
    IDKeyLib = Trim(InputBox("TypeLib ClassID not found from Addin.  Enter TypeLib ClassID."))
    If IDKeyLib = "" Then MsgBox "Can't Proceed.  Terminating"
End If
If regDoes_Key_Exist(HKEY_CLASSES_ROOT, "TypeLib\" & IDKeyLib) Then _
    AddKeyToColl HKEY_CLASSES_ROOT, "TypeLib\" & IDKeyLib
If regDoes_Key_Exist(HKEY_LOCAL_MACHINE, "Software\Classes\TypeLib\" & IDKeyLib) Then _
    AddKeyToColl HKEY_LOCAL_MACHINE, "Software\Classes\TypeLib\" & IDKeyLib

'3.) canvass for keys referencing app ClassID as TypeLib
CanvassForTypeLib

'4.) get class-named keys
GetClassNamedKeys

'5.) get AppID keys
If regDoes_Key_Exist(HKEY_CLASSES_ROOT, "AppID\" & IDAddin) Then _
    AddKeyToColl HKEY_CLASSES_ROOT, "AppID\" & IDAddin
If regDoes_Key_Exist(HKEY_LOCAL_MACHINE, "Software\Classes\AppID\" & IDAddin) Then _
    AddKeyToColl HKEY_LOCAL_MACHINE, "Software\Classes\AppID\" & IDAddin

'6.) Get SW user addin keys
GetSWAddinKeys

'7.) Nuke Toolbar Data
If ToolBar > "" Then NukeToolbarData

'load app keys to listbox
AppKeysToListBox
ToolKeysToListBox

frmLongTime.Hide
Unload frmLongTime
End Sub
Sub AddKeyToColl(lngHKEY As Long, strInKey As String)
Dim NewKey As New TargetKey
NewKey.HK = lngHKEY
NewKey.KeyName = strInKey
KeyColl.Add Item:=NewKey
Set NewKey = Nothing
End Sub
Sub AddToolToColl(lngHKEY As Long, strInKey As String)
Dim NewKey As New TargetKey
NewKey.HK = lngHKEY
NewKey.KeyName = strInKey
ToolColl.Add Item:=NewKey
Set NewKey = Nothing
End Sub
Sub CanvassForTypeLib()
Dim cRoots(1 To 4) As Long
Dim cKeys(1 To 4) As String
Dim Cindex As Long
Dim cEnum As Long
Dim cEndFlag As Boolean
Dim cRetLong As Long
Dim cOutKey As String

'set up roots and keys
cRoots(1) = HKEY_CLASSES_ROOT
cKeys(1) = "CLSID\"

cRoots(2) = HKEY_CLASSES_ROOT
cKeys(2) = "Interface\"

cRoots(3) = HKEY_LOCAL_MACHINE
cKeys(3) = "Software\Classes\CLSID\"

cRoots(4) = HKEY_LOCAL_MACHINE
cKeys(4) = "Software\Classes\Interface\"

For Cindex = 1 To 4
    cEnum = 0
    Do
    DoEvents
        cOutKey = ""
        cRetLong = regEnumerate_Key(cRoots(Cindex), cKeys(Cindex), cEnum, cOutKey)
        If cRetLong <> 0 Then Exit Do
        If regDoes_Key_Exist(cRoots(Cindex), cKeys(Cindex) & cOutKey & "\TypeLib") Then
            If CStr(regQuery_A_Key(cRoots(Cindex), cKeys(Cindex) & cOutKey & "\TypeLib", "")) = IDKeyLib Then
                AddKeyToColl cRoots(Cindex), cKeys(Cindex) & cOutKey
            End If
        End If
        cEnum = cEnum + 1
    Loop
Next

End Sub
Sub GetClassNamedKeys()

If regDoes_Key_Exist(HKEY_CLASSES_ROOT, "clsid\" & IDAddin) Then
    ConnName = CStr(regQuery_A_Key(HKEY_CLASSES_ROOT, "clsid\" & IDAddin, ""))
Else
    Exit Sub
End If
If regDoes_Key_Exist(HKEY_CLASSES_ROOT, ConnName) Then AddKeyToColl HKEY_CLASSES_ROOT, ConnName
If regDoes_Key_Exist(HKEY_LOCAL_MACHINE, "software\classes\" & ConnName) Then AddKeyToColl HKEY_LOCAL_MACHINE, "software\classes\" & ConnName

End Sub
Sub GetSWAddinKeys()
Dim swUser As String
Dim sEnum As Long
Dim lRet As Long

sEnum = 0
Do
    swUser = ""
    lRet = regEnumerate_Key(HKEY_USERS, "", sEnum, swUser)
    If lRet <> 0 Then Exit Do
    If regDoes_Key_Exist(HKEY_USERS, swUser & "\Software\SolidWorks\AddInsStartup\" & IDAddin) Then _
        AddKeyToColl HKEY_USERS, swUser & "\Software\SolidWorks\AddInsStartup\" & IDAddin
    sEnum = sEnum + 1
Loop

If regDoes_Key_Exist(HKEY_CURRENT_USER, "Software\SolidWorks\AddInsStartup\" & IDAddin) Then
    AddKeyToColl HKEY_CURRENT_USER, "Software\SolidWorks\AddInsStartup\" & IDAddin
End If
End Sub

Sub NukeToolbarData()
Dim E1 As Long, E2 As Long
Dim T1 As String, T2(1 To 3) As String, BigT As String
Dim eK As String, swUser As String, swKey As String
Dim lRet As Long
Dim nI As Long 'loop index

On Error Resume Next
T1 = "Software\SolidWorks"
T2(1) = "User Interface\Toolbars\AssemblyTool"
T2(2) = "User Interface\Toolbars\PartTool"
T2(3) = "User Interface\Toolbars\DrawingTool"

'HKEY_CURRENT_USER\Software\SolidWorks\SolidWorks 2001Plus\User Interface\Toolbars\AssemblyTool
'HKEY_CURRENT_USER\Software\SolidWorks\[swKey]\User Interface\Toolbars\AssemblyTool


'HKEY_USERS\S-1-5-21-2123657697-1667787894-704538537-2004\Software\SolidWorks\SolidWorks 2003\User Interface\Toolbars\AssemblyTool
'HKEY_USERS\[swUser]\Software\SolidWorks\[swKey]\User Interface\Toolbars\AssemblyTool
E1 = 0
Do
    'loop 1 = users
    swUser = ""
    lRet = regEnumerate_Key(HKEY_USERS, "", E1, swUser)
    If lRet <> 0 Then Exit Do
    E2 = 0
    Do
        'loop 2 = keys under
        'HKEY_USERS\[swUser]\Software\SolidWorks\
        swKey = ""
        lRet = regEnumerate_Key(HKEY_USERS, swUser & "\" & T1, E2, swKey)
        If lRet <> 0 Then Exit Do
        'loop through toolbars Assembly, Part, Drawing
        For nI = 1 To 3
            BigT = swUser & "\" & T1 & "\" & swKey & "\" & T2(nI)
            If regDoes_Key_Exist(HKEY_USERS, BigT) Then AddToolToColl HKEY_USERS, BigT
        Next
        E2 = E2 + 1
    Loop
    E1 = E1 + 1
Loop

End Sub
Sub LoadKeyCodex()
Set KeyCodex = CreateObject("Scripting.Dictionary")

With KeyCodex
    .CompareMode = TextCompare
    .Add CStr(HKEY_CLASSES_ROOT), "HKEY_CLASSES_ROOT"
    .Add "HKEY_CLASSES_ROOT", CStr(HKEY_CLASSES_ROOT)
    
    .Add CStr(HKEY_CURRENT_CONFIG), "HKEY_CURRENT_CONFIG"
    .Add "HKEY_CURRENT_CONFIG", CStr(HKEY_CURRENT_CONFIG)
    
    .Add CStr(HKEY_CURRENT_USER), "HKEY_CURRENT_USER"
    .Add "HKEY_CURRENT_USER", CStr(HKEY_CURRENT_USER)
    
    .Add CStr(HKEY_DYN_DATA), "HKEY_DYN_DATA"
    .Add "HKEY_DYN_DATA", CStr(HKEY_DYN_DATA)
    
    .Add CStr(HKEY_LOCAL_MACHINE), "HKEY_LOCAL_MACHINE"
    .Add "HKEY_LOCAL_MACHINE", CStr(HKEY_LOCAL_MACHINE)
    
    .Add CStr(HKEY_PERFORMANCE_DATA), "HKEY_PERFORMANCE_DATA"
    .Add "HKEY_PERFORMANCE_DATA", CStr(HKEY_PERFORMANCE_DATA)
    
    .Add CStr(HKEY_USERS), "HKEY_USERS"
    .Add "HKEY_USERS", CStr(HKEY_USERS)
End With

End Sub

Sub AppKeysToListBox()
Dim lKey As String

lblKeyNames.Caption = "Addin Application Key: " & IDKeyLib & Chr(13) & Chr(10) & _
    "SW Connection Class Key: " & IDAddin & Chr(13) & Chr(10) & _
    "SW Toolbar name: " & ToolBar
    
lboAppKeys.Clear

For Each AK In KeyColl
    lKey = KeyCodex(CStr(AK.HK)) & "\" & AK.KeyName
    lboAppKeys.AddItem (lKey)
    lboAppKeys.Selected(lboAppKeys.ListCount - 1) = True
Next

End Sub
Sub ToolKeysToListBox()
Dim lKey As String

lboToolbarKeys.Clear

For Each AK In ToolColl
    lKey = KeyCodex(CStr(AK.HK)) & "\" & AK.KeyName
    lboToolbarKeys.AddItem (lKey)
    lboToolbarKeys.Selected(lboToolbarKeys.ListCount - 1) = True
Next

End Sub
Public Function ParsePath(FullString As String, ParseChar As String, FromEnd As Long) As Variant
'divides a string on either side of a specified character
'FromEnd: =-1: first ParseChar from left; =1: first ParseChar from right
'ParsePath(1)=left side of dividing character from ParseChar
'ParsePath(2)=dividing character
'ParsePath(3)=right side
'returns all vbNullstrings if ParseChar not found

If Len(ParseChar) < 1 Then Exit Function

Dim ParseParams(1 To 3) As String
Dim ParseString As String 'working copy of FullString
Dim ParseCharString As String 'working copy of ParseChar
Dim ParseCharPos As Long
Dim iParse As Integer 'index for loop
Dim TempString As String 'for swapping positions

For iParse = 1 To 3
    ParseParams(iParse) = vbNullString
Next

'reverse string if parsing from right
If Sgn(FromEnd) = -1 Or Val(FromEnd) = 0 Then 'from LEFT
    ParseString = FullString
    ParseCharString = ParseChar
Else 'from RIGHT
    ParseString = StrReverse(FullString)
    ParseCharString = StrReverse(ParseChar)
End If

ParseCharPos = InStr(1, ParseString, ParseCharString, vbTextCompare)
If ParseCharPos > 0 Then
    ParseParams(1) = Left(ParseString, (ParseCharPos - 1))
    ParseParams(2) = ParseChar
    ParseParams(3) = Right(ParseString, Len(FullString) - (Len(ParseParams(1)) + Len(ParseCharString)))
    
    If Sgn(Val(FromEnd)) = 1 Then
        TempString = StrReverse(ParseParams(1))
        ParseParams(1) = StrReverse(ParseParams(3))
        ParseParams(3) = TempString
    End If
End If

ParsePath = ParseParams
End Function
'===================================
'Function BrowseFolder() As String
'this function removed
'End Function
'===================================

Sub PauseForXSeconds(pTime As Single)
Dim Finish As Single

Finish = Timer + pTime

Do While Timer < Finish
    DoEvents    ' Yield to other processes.
Loop

End Sub
