Attribute VB_Name = "Module1"
Option Explicit
Option Private Module

' --------------------------------------------------------------
' Update the Windows registry.
' Written by Kenneth Ives                        kenaso@home.com
' NT tested by Brett Gerhardi       Brett.Gerhardi@trinite.co.uk
'
' Perform the four basic functions on the Windows registry.
'           Add
'           Change
'           Delete
'           Query
'
' Important:   If you treat all key data strings as being
'              case sensitive, you should never have a problem.
'              Always backup your registry files (System.dat
'              and User.dat) before performing any type of
'              modifications
'
' Software developers vary on where they want to update the
' registry with their particular information.  The most common
' are in HKEY_lOCAL_MACHINE or HKEY_CURRENT_USER.
'
' This BAS module handles all of my needs for string and
' basic numeric updates in the Windows registry.
'
' Brett found that NT users must delete each major key
' separately.  See bottom of TEST routine for an example.
' --------------------------------------------------------------

' --------------------------------------------------------------
' Private variables
' --------------------------------------------------------------
  Private m_lngRetVal As Long
  
' --------------------------------------------------------------
' Constants required for values in the keys
' --------------------------------------------------------------
  Private Const REG_NONE As Long = 0                  ' No value type
  Private Const REG_SZ As Long = 1                    ' nul terminated string
  Private Const REG_EXPAND_SZ As Long = 2             ' nul terminated string w/enviornment var
  Private Const REG_BINARY As Long = 3                ' Free form binary
  Private Const REG_DWORD As Long = 4                 ' 32-bit number
  Private Const REG_DWORD_LITTLE_ENDIAN As Long = 4   ' 32-bit number (same as REG_DWORD)
  Private Const REG_DWORD_BIG_ENDIAN As Long = 5      ' 32-bit number
  Private Const REG_LINK As Long = 6                  ' Symbolic Link (unicode)
  Private Const REG_MULTI_SZ As Long = 7              ' Multiple Unicode strings
  Private Const REG_RESOURCE_LIST As Long = 8         ' Resource list in the resource map
  Private Const REG_FULL_RESOURCE_DESCRIPTOR As Long = 9 ' Resource list in the hardware description
  Private Const REG_RESOURCE_REQUIREMENTS_LIST As Long = 10

' --------------------------------------------------------------
' Registry Specific Access Rights
' --------------------------------------------------------------
Private Const KEY_CREATE_LINK = &H20
Private Const KEY_CREATE_SUB_KEY = &H4
Private Const KEY_ENUMERATE_SUB_KEYS = &H8
Private Const KEY_NOTIFY = &H10
Private Const KEY_QUERY_VALUE = &H1
Private Const KEY_SET_VALUE = &H2

Private Const READ_CONTROL = &H20000

Private Const STANDARD_RIGHTS_ALL = &H1F0000
Private Const STANDARD_RIGHTS_EXECUTE = (READ_CONTROL)
Private Const STANDARD_RIGHTS_READ = (READ_CONTROL)
Private Const STANDARD_RIGHTS_REQUIRED = &HF0000
Private Const STANDARD_RIGHTS_WRITE = (READ_CONTROL)

Private Const SYNCHRONIZE = &H100000

Private Const KEY_WRITE = ((STANDARD_RIGHTS_WRITE Or KEY_SET_VALUE Or KEY_CREATE_SUB_KEY) And (Not SYNCHRONIZE))
Private Const KEY_READ = ((STANDARD_RIGHTS_READ Or KEY_QUERY_VALUE Or KEY_ENUMERATE_SUB_KEYS Or KEY_NOTIFY) And (Not SYNCHRONIZE))
Private Const KEY_ALL_ACCESS = ((STANDARD_RIGHTS_ALL Or KEY_QUERY_VALUE Or KEY_SET_VALUE Or KEY_CREATE_SUB_KEY Or KEY_ENUMERATE_SUB_KEYS Or KEY_NOTIFY Or KEY_CREATE_LINK) And (Not SYNCHRONIZE))
Private Const KEY_EXECUTE = ((KEY_READ) And (Not SYNCHRONIZE))

' --------------------------------------------------------------
' Constants required for key locations in the registry
' --------------------------------------------------------------
  Public Const HKEY_CLASSES_ROOT As Long = &H80000000
  Public Const HKEY_CURRENT_USER As Long = &H80000001
  Public Const HKEY_LOCAL_MACHINE As Long = &H80000002
  Public Const HKEY_USERS As Long = &H80000003
  Public Const HKEY_PERFORMANCE_DATA As Long = &H80000004
  Public Const HKEY_CURRENT_CONFIG As Long = &H80000005
  Public Const HKEY_DYN_DATA As Long = &H80000006

' --------------------------------------------------------------
' Constants required for return values (Error code checking)
' --------------------------------------------------------------
  Public Const ERROR_SUCCESS As Long = 0
  Public Const ERROR_ACCESS_DENIED As Long = 5
  Public Const ERROR_MORE_DATA = 234 '  dderror
  Public Const ERROR_NO_MORE_ITEMS As Long = 259

' --------------------------------------------------------------
' Open/Create constants
' --------------------------------------------------------------
  Private Const REG_OPTION_NON_VOLATILE As Long = 0
  Private Const REG_OPTION_VOLATILE As Long = &H1

' --------------------------------------------------------------
' Constants added for registry key save/restore Feb. 5, 2004 by RECS
' --------------------------------------------------------------
Private Const TOKEN_QUERY As Long = &H8&
Private Const TOKEN_ADJUST_PRIVILEGES As Long = &H20&

Private Const SE_PRIVILEGE_ENABLED As Long = &H2
Private Const SE_RESTORE_NAME = "SeRestorePrivilege" 'Important for what we're trying to accomplish
Private Const SE_BACKUP_NAME = "SeBackupPrivilege"

Private Const SPECIFIC_RIGHTS_ALL = &HFFFF

Private Const REG_FORCE_RESTORE As Long = 8& ' Almost as import, will allow you to restore over a key while it's open

' --------------------------------------------------------------
' enumeration added for create value type in regCreate_Key_Value
'Roland Schwarz Feb. 7, 2004
' --------------------------------------------------------------
Enum regValueType_e
    regDoNotForce = 0
    regForceDWORD = 1
    regForceSTRING = 2
    regForceBINARY = 3
End Enum


' --------------------------------------------------------------
' Miscellaneous
' --------------------------------------------------------------
  Private Const BUFFER_SIZE = 255
  Private Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
  
  Private Const ZEROBYTE As Byte = 0&
  

' --------------------------------------------------------------
' Types added for save/restore to registry Feb. 5, 2004
' --------------------------------------------------------------
Private Type LUID
   lowpart As Long
   highpart As Long
End Type

Private Type LUID_AND_ATTRIBUTES
   pLuid As LUID
   Attributes As Long
End Type

Private Type TOKEN_PRIVILEGES
   PrivilegeCount As Long
   Privileges As LUID_AND_ATTRIBUTES
End Type

' --------------------------------------------------------------
' Declarations required to access the Windows registry
' --------------------------------------------------------------
Private Declare Function AdjustTokenPrivileges Lib "advapi32.dll" _
    (ByVal TokenHandle As Long, _
    ByVal DisableAllPriv As Long, _
    NewState As TOKEN_PRIVILEGES, _
    ByVal BufferLength As Long, _
    PreviousState As TOKEN_PRIVILEGES, _
    ReturnLength As Long) _
As Long 'Used to adjust your program's security privileges, can't restore without it!

Private Declare Function GetCurrentProcess Lib "kernel32" () As Long

Private Declare Function LookupPrivilegeValue Lib "advapi32.dll" Alias "LookupPrivilegeValueA" _
    (ByVal lpSystemName As Any, _
    ByVal lpName As String, _
    lpLuid As LUID) _
As Long 'Returns a valid LUID which is important when making security changes in NT.

Private Declare Function OpenProcessToken Lib "advapi32.dll" _
    (ByVal ProcessHandle As Long, _
    ByVal DesiredAccess As Long, _
    TokenHandle As Long) _
As Long

Private Declare Function RegCloseKey Lib "advapi32.dll" _
(ByVal lngRootKey As Long) _
As Long

Private Declare Function RegCreateKey Lib "advapi32.dll" Alias "RegCreateKeyA" _
(ByVal lngRootKey As Long, _
ByVal lpSubKey As String, _
phkResult As Long) _
As Long

Private Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" _
(ByVal lngRootKey As Long, _
ByVal lpSubKey As String) _
As Long

Private Declare Function RegDeleteValue Lib "advapi32.dll" Alias "RegDeleteValueA" _
(ByVal lngRootKey As Long, _
ByVal lpValueName As String) _
As Long

Private Declare Function RegEnumKeyEx Lib "advapi32.dll" Alias "RegEnumKeyExA" _
(ByVal hKey As Long, _
ByVal dwIndex As Long, _
ByVal lpName As String, _
lpcbName As Long, _
ByVal lpReserved As Long, _
ByVal lpClass As String, _
lpcbClass As Long, _
lpftLastWriteTime As Any) _
As Long
'lpftLastWriteTime As Any was As FILETIME

Private Declare Function RegEnumValue Lib "advapi32.dll" Alias "RegEnumValueA" (ByVal hKey As Long, ByVal dwIndex As Long, ByVal lpValueName As String, lpcbValueName As Long, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
'lpReserved must be NULL or 0
'lpData usually not needed and set to NULL or 0&

Private Declare Function RegFlushKey Lib "advapi32.dll" _
    (ByVal hKey As Long) As Long

Private Declare Function RegOpenKey Lib "advapi32.dll" Alias "RegOpenKeyA" _
(ByVal lngRootKey As Long, _
ByVal lpSubKey As String, _
phkResult As Long) _
As Long

Public Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" _
    (ByVal hKey As Long, _
    ByVal lpSubKey As String, _
    ByVal ulOptions As Long, _
    ByVal samDesired As Long, _
    phkResult As Long) _
    As Long

Private Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" _
(ByVal lngRootKey As Long, _
ByVal lpValueName As String, _
ByVal lpReserved As Long, _
lpType As Long, _
lpData As Any, _
lpcbData As Long) _
As Long

Private Declare Function regRestoreKey Lib "advapi32.dll" Alias "RegRestoreKeyA" _
    (ByVal hKey As Long, _
    ByVal lpFile As String, _
    ByVal dwFlags As Long) _
As Long ' Main function
    
Private Declare Function regSaveKey Lib "advapi32.dll" Alias "RegSaveKeyA" _
    (ByVal hKey As Long, _
    ByVal lpFile As String, _
    lpSecurityAttributes As Any) _
As Long

Private Declare Function RegSetValueEx Lib "advapi32.dll" Alias "RegSetValueExA" _
    (ByVal lngRootKey As Long, _
    ByVal lpValueName As String, _
    ByVal Reserved As Long, _
    ByVal dwType As Long, _
    lpData As Any, _
    ByVal cbData As Long) _
As Long

'for reading errors
Public Declare Function FormatMessage Lib "kernel32" Alias "FormatMessageA" ( _
    ByVal dwFlags As Long, _
    lpSource As Any, _
    ByVal dwMessageId As Long, _
    ByVal dwLanguageId As Long, _
    ByVal lpBuffer As String, _
    ByVal nSize As Long, _
    Arguments As Long) _
    As Long
Private Sub ParseKeyPath(InString As String, ByRef OutLeft As String, ByRef OutRight As String)

Dim ParseParams(1 To 3) As String
Dim ParseString As String 'working copy of FullString
Dim ParseCharString As String 'working copy of ParseChar
Dim ParseCharPos As Long
Dim iParse As Integer 'index for loop
Dim TempString As String 'for swapping positions

For iParse = 1 To 3
    ParseParams(iParse) = vbNullString
Next

''from RIGHT
    ParseString = StrReverse(InString)
    ParseCharString = "\"


ParseCharPos = InStr(1, ParseString, ParseCharString, vbTextCompare)
If ParseCharPos > 0 Then
    ParseParams(1) = Left(ParseString, (ParseCharPos - 1))
    ParseParams(2) = ParseCharString
    ParseParams(3) = Right(ParseString, Len(ParseString) - (Len(ParseParams(1)) + Len(ParseCharString)))

    TempString = StrReverse(ParseParams(1))
    ParseParams(1) = StrReverse(ParseParams(3))
    ParseParams(3) = TempString
End If

OutLeft = CStr(ParseParams(1))
OutRight = CStr(ParseParams(3))

End Sub

Private Function EnablePrivilege(seName As String) As Boolean
'used by regRestoreKey and regSaveKey

    Dim p_lngRtn As Long
    Dim p_lngToken As Long
    Dim p_lngBufferLen As Long
    Dim p_typLUID As LUID
    Dim p_typTokenPriv As TOKEN_PRIVILEGES
    Dim p_typPrevTokenPriv As TOKEN_PRIVILEGES
    p_lngRtn = OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES Or TOKEN_QUERY, p_lngToken)
    If p_lngRtn = 0 Then
        Exit Function ' Failed
    ElseIf Err.LastDllError <> 0 Then
        Exit Function ' Failed
    End If
    p_lngRtn = LookupPrivilegeValue(0&, seName, p_typLUID)  'Used to look up privileges LUID.
    If p_lngRtn = 0 Then
        Exit Function ' Failed
    End If
    ' Set it up to adjust the program's security privilege.
    p_typTokenPriv.PrivilegeCount = 1
    p_typTokenPriv.Privileges.Attributes = SE_PRIVILEGE_ENABLED
    p_typTokenPriv.Privileges.pLuid = p_typLUID
    EnablePrivilege = (AdjustTokenPrivileges(p_lngToken, False, p_typTokenPriv, Len(p_typPrevTokenPriv), p_typPrevTokenPriv, p_lngBufferLen) <> 0)
End Function
Public Function regCreate_A_Key(ByVal lngRootKey As Long, ByVal strRegKeyPath As String)

' --------------------------------------------------------------
' Written by Kenneth Ives                     kenaso@home.com
'
' Important:     If you treat all key data strings as being
'                case sensitive, you should never have a problem.
'                Always backup your registry files (System.dat
'                and User.dat) before performing any type of
'                modifications
'
' Description:   This function will create a new key
'
' Parameters:
'          lngRootKey  - HKEY_CLASSES_ROOT, HKEY_CURRENT_USER,
'                  HKEY_lOCAL_MACHINE, HKEY_USERS, etc
'   strRegKeyPath  - is name of the key you wish to create.
'                  to make sub keys, continue to make this
'                  call with each new level.  MS says you
'                  can do this in one call; however, the
'                  best laid plans of mice and men ...
'
' Syntax:
'   regCreate_A_Key HKEY_CURRENT_USER, "Software\AAA-Registry Test"
'   regCreate_A_Key HKEY_CURRENT_USER, "Software\AAA-Registry Test\Products"
' --------------------------------------------------------------

' --------------------------------------------------------------
' Define variables
' --------------------------------------------------------------
  Dim lngKeyHandle As Long
  
' --------------------------------------------------------------
' Create the key.  If it already exist, ignore it.
' --------------------------------------------------------------
  m_lngRetVal = RegCreateKey(lngRootKey, strRegKeyPath, lngKeyHandle)

' --------------------------------------------------------------
' Always close the handle in the registry.  We do not want to
' corrupt these files.
' --------------------------------------------------------------
  m_lngRetVal = RegCloseKey(lngKeyHandle)
  
End Function
Public Sub regCreate_Key_Value(ByVal lngRootKey As Long, ByVal strRegKeyPath As String, _
                               ByVal strRegSubKey As String, varRegData As Variant, Optional ForceDataType As regValueType_e = regDoNotForce)
    
' --------------------------------------------------------------
' Written by Kenneth Ives                     kenaso@home.com
'
' Important:     If you treat all key data strings as being
'                case sensitive, you should never have a problem.
'                Always backup your registry files (System.dat
'                and User.dat) before performing any type of
'                modifications
'
' Description:   Function for saving string data.
'
' Parameters:
'           lngRootKey - HKEY_CLASSES_ROOT, HKEY_CURRENT_USER,
'                  HKEY_lOCAL_MACHINE, HKEY_USERS, etc
'    strRegKeyPath - is name of the key path you wish to traverse.
'     strRegSubKey - is the name of the key which will be updated.
'       varRegData - Update data.
'
' Syntax:
'    regCreate_Key_Value HKEY_CURRENT_USER, _
'                      "Software\AAA-Registry Test\Products", _
'                      "StringTestData", "22 Jun 1999"
'
' Saves the key value of "22 Jun 1999" to sub key "StringTestData"
' --------------------------------------------------------------
    
' --------------------------------------------------------------
' Define variables
' --------------------------------------------------------------
  Dim lngKeyHandle As Long
  Dim lngDataType As Long
  Dim lngKeyValue As Long
  Dim strKeyValue As String
  
' --------------------------------------------------------------
' Determine the type of data to be updated
' --------------------------------------------------------------
Select Case ForceDataType
    Case regForceDWORD
        'check for hex or octal
        If (Left(CStr(varRegData), 2) = "&h" Or Left(CStr(varRegData), 2) = "&o") _
            And IsNumeric(Right(CStr(varRegData), Len(CStr(varRegData)) - 2)) Then _
            varRegData = CLng(varRegData)
        'convert to value
        varRegData = Val(varRegData)
        lngDataType = REG_DWORD
    Case regForceBINARY
        'check for hex or octal
        If (Left(CStr(varRegData), 2) = "&h" Or Left(CStr(varRegData), 2) = "&o") _
            And IsNumeric(Right(CStr(varRegData), Len(CStr(varRegData)) - 2)) Then _
            varRegData = CLng(varRegData)
        'convert to value
        varRegData = Val(varRegData)
        lngDataType = REG_BINARY
    Case regForceSTRING
        varRegData = CStr(varRegData)
        lngDataType = REG_SZ
    Case regDoNotForce
        'check for hex or octal
        If (Left(CStr(varRegData), 2) = "&h" Or Left(CStr(varRegData), 2) = "&o") _
            And IsNumeric(Right(CStr(varRegData), Len(CStr(varRegData)) - 2)) Then _
            varRegData = CLng(varRegData)
        If IsNumeric(varRegData) Then
            lngDataType = REG_DWORD
        Else
            lngDataType = REG_SZ
        End If
End Select
  
' --------------------------------------------------------------
' Query the key path
' --------------------------------------------------------------
  m_lngRetVal = RegCreateKey(lngRootKey, strRegKeyPath, lngKeyHandle)
    
' --------------------------------------------------------------
' Update the sub key based on the data type
' --------------------------------------------------------------
  Select Case lngDataType
         Case REG_SZ:       ' String data
              strKeyValue = Trim(varRegData) & Chr(0)     ' null terminated
              m_lngRetVal = RegSetValueEx(lngKeyHandle, strRegSubKey, 0&, lngDataType, _
                                          ByVal strKeyValue, Len(strKeyValue))
                                   
         Case REG_DWORD:    ' numeric data
              lngKeyValue = CLng(varRegData)
              m_lngRetVal = RegSetValueEx(lngKeyHandle, strRegSubKey, 0&, lngDataType, _
                                          lngKeyValue, 4&)  ' 4& = 4-byte word (long integer)
                                          
        Case REG_BINARY 'binary
              lngKeyValue = CLng(varRegData)
              m_lngRetVal = RegSetValueEx(lngKeyHandle, strRegSubKey, 0&, lngDataType, _
                                          lngKeyValue, 4&)  ' 4& = 4-byte word (long integer)
  End Select
  
' --------------------------------------------------------------
' Always close the handle in the registry.  We do not want to
' corrupt these files.
' --------------------------------------------------------------
  m_lngRetVal = RegCloseKey(lngKeyHandle)
  
End Sub
Public Function regDelete_A_Key(ByVal lngRootKey As Long, _
                                ByVal strRegKeyPath As String, _
                                ByVal strRegKeyName As String) As Boolean
    
' --------------------------------------------------------------
' Written by Kenneth Ives                     kenaso@home.com
'
' Important:     If you treat all key data strings as being
'                case sensitive, you should never have a problem.
'                Always backup your registry files (System.dat
'                and User.dat) before performing any type of
'                modifications
'
' Description:   Function for removing a complete key.
'
' Parameters:
'           lngRootKey - HKEY_CLASSES_ROOT, HKEY_CURRENT_USER,
'                        HKEY_lOCAL_MACHINE, HKEY_USERS, etc
'    strRegKeyPath - is name of the key path you wish to traverse.
'   strRegKeyValue - is the name of the key which will be removed.
'
' Returns a True or False on completion.
'
' Syntax:
'    regDelete_A_Key HKEY_CURRENT_USER, "Software", "AAA-Registry Test"
'
' Removes the key "AAA-Registry Test" and all of its sub keys.
' --------------------------------------------------------------
    
' --------------------------------------------------------------
' Define variables
' --------------------------------------------------------------
  Dim lngKeyHandle As Long
  
' --------------------------------------------------------------
' Preset to a failed delete
' --------------------------------------------------------------
  regDelete_A_Key = False
  
' --------------------------------------------------------------
' Make sure the key exist before trying to delete it
' --------------------------------------------------------------
  If regDoes_Key_Exist(lngRootKey, strRegKeyPath) Then
  
      ' Get the key handle
      m_lngRetVal = RegOpenKey(lngRootKey, strRegKeyPath, lngKeyHandle)
      
      ' Delete the key
      m_lngRetVal = RegDeleteKey(lngKeyHandle, strRegKeyName)
      
      ' If the value returned is equal zero then we have succeeded
      If m_lngRetVal = 0 Then regDelete_A_Key = True
      
      ' Always close the handle in the registry.  We do not want to
      ' corrupt the registry.
      m_lngRetVal = RegCloseKey(lngKeyHandle)
  End If
  
End Function
Public Function regDelete_Key_And_Subkeys(lngRootKey As Long, strDeleteKey) As Boolean

Dim ThisRoot As Long
Dim ThisKey As String
Dim ThisKeyLEFT As String
Dim ThisKeyRIGHT As String
Dim NextKey As String

ThisRoot = lngRootKey
ThisKey = strDeleteKey
ParseKeyPath ThisKey, ThisKeyLEFT, ThisKeyRIGHT

Do
    If regEnumerate_Key(ThisRoot, ThisKey, 0, NextKey) = ERROR_NO_MORE_ITEMS _
        Then Exit Do
    NextKey = ThisKey & "\" & NextKey
    regDelete_Key_And_Subkeys ThisRoot, NextKey
Loop

regDelete_Key_And_Subkeys = regDelete_A_Key(lngRootKey, ThisKeyLEFT, ThisKeyRIGHT)

End Function
Public Function regDelete_Subkeys_but_Keep_Key(lngRootKey As Long, strDeleteKey) As Boolean

Dim ThisRoot As Long
Dim ThisKey As String
Dim ThisKeyLEFT As String
Dim ThisKeyRIGHT As String
Dim NextKey As String

ThisRoot = lngRootKey
ThisKey = strDeleteKey
ParseKeyPath ThisKey, ThisKeyLEFT, ThisKeyRIGHT

Do
    If regEnumerate_Key(ThisRoot, ThisKey, 0, NextKey) = ERROR_NO_MORE_ITEMS _
        Then Exit Do
    NextKey = ThisKey & "\" & NextKey
    regDelete_Key_And_Subkeys ThisRoot, NextKey
Loop

End Function



Public Function regDelete_Key_Value(ByVal lngRootKey As Long, _
                                  ByVal strRegKeyPath As String, _
                                  ByVal strRegSubKey As String)
    
' --------------------------------------------------------------
' Written by Kenneth Ives                     kenaso@home.com
'
' Important:     If you treat all key data strings as being
'                case sensitive, you should never have a problem.
'                Always backup your registry files (System.dat
'                and User.dat) before performing any type of
'                modifications
'
' Description:   Function for removing a sub key.
'
' Parameters:
'           lngRootKey - HKEY_CLASSES_ROOT, HKEY_CURRENT_USER,
'                  HKEY_lOCAL_MACHINE, HKEY_USERS, etc
'    strRegKeyPath - is name of the key path you wish to traverse.
'     strRegSubKey - is the name of the key which will be removed.
'
' Syntax:
'    regDelete_Key_Value HKEY_CURRENT_USER, _
                  "Software\AAA-Registry Test\Products", "StringTestData"
'
' Removes the sub key "StringTestData"
' --------------------------------------------------------------
    
' --------------------------------------------------------------
' Define variables
' --------------------------------------------------------------
  Dim lngKeyHandle As Long
  
' --------------------------------------------------------------
' Make sure the key exist before trying to delete it
' --------------------------------------------------------------
  If regDoes_Key_Exist(lngRootKey, strRegKeyPath) Then
  
      ' Get the key handle
      m_lngRetVal = RegOpenKey(lngRootKey, strRegKeyPath, lngKeyHandle)
      
      ' Delete the sub key.  If it does not exist, then ignore it.
      m_lngRetVal = RegDeleteValue(lngKeyHandle, strRegSubKey)
  
      ' Always close the handle in the registry.  We do not want to
      ' corrupt the registry.
      m_lngRetVal = RegCloseKey(lngKeyHandle)
  End If
  
End Function
Public Function regDoes_Key_Exist(ByVal lngRootKey As Long, _
                                  ByVal strRegKeyPath As String) As Boolean
    
' --------------------------------------------------------------
' Written by Kenneth Ives                     kenaso@home.com
'
' Important:     If you treat all key data strings as being
'                case sensitive, you should never have a problem.
'                Always backup your registry files (System.dat
'                and User.dat) before performing any type of
'                modifications
'
' Description:   Function to see if a key does exist
'
' Parameters:
'           lngRootKey - HKEY_CLASSES_ROOT, HKEY_CURRENT_USER,
'                  HKEY_lOCAL_MACHINE, HKEY_USERS, etc
'    strRegKeyPath - is name of the key path you want to test
'
' Syntax:
'    strKeyQuery = regQuery_A_Key(HKEY_CURRENT_USER, _
'                       "Software\AAA-Registry Test\Products")
'
' Returns the value of TRUE or FALSE
' --------------------------------------------------------------
    
' --------------------------------------------------------------
' Define variables
' --------------------------------------------------------------
  Dim lngKeyHandle As Long

' --------------------------------------------------------------
' Initialize variables
' --------------------------------------------------------------
  lngKeyHandle = 0
  
' --------------------------------------------------------------
' Query the key path
' --------------------------------------------------------------
  m_lngRetVal = RegOpenKey(lngRootKey, strRegKeyPath, lngKeyHandle)
  
' --------------------------------------------------------------
' If no key handle was found then there is no key.  Leave here.
' --------------------------------------------------------------
  If lngKeyHandle = 0 Then
      regDoes_Key_Exist = False
  Else
      regDoes_Key_Exist = True
  End If
  
' --------------------------------------------------------------
' Always close the handle in the registry.  We do not want to
' corrupt these files.
' --------------------------------------------------------------
  m_lngRetVal = RegCloseKey(lngKeyHandle)
  
End Function
Public Function regEnumerate_Key(lngRootKey As Long, strRegKeyPath As String, _
    lngIndex As Long, Optional ByRef strOutKey As String) As Long
'return 0 = success
Dim lngHandle As Long
Dim lngRetBuffer As Long
Dim OutString As String
Dim useIndex As Long

regEnumerate_Key = RegOpenKeyEx(lngRootKey, strRegKeyPath, 0&, _
    KEY_ALL_ACCESS, lngHandle)
'lngandle used to enumerate and close
If regEnumerate_Key <> 0 Then
    strOutKey = "Key not opened" 'vbNullString
    Exit Function
End If

'key found and opened
'set buffer size and string
useIndex = lngIndex
lngRetBuffer = BUFFER_SIZE
OutString = Space(BUFFER_SIZE)
'variables initialized
regEnumerate_Key = RegEnumKeyEx(lngHandle, useIndex, OutString, lngRetBuffer, _
    ByVal 0&, vbNullString, ByVal 0&, ByVal 0&)
'last 4 arguments copied from RegEnumEx example in AllAPI.net

If lngRetBuffer > Len(OutString) Then
    OutString = Space(lngRetBuffer + 1)
    lngRetBuffer = lngRetBuffer + 1
    regEnumerate_Key = RegEnumKeyEx(lngHandle, useIndex, OutString, lngRetBuffer, _
        ByVal 0&, vbNullString, ByVal 0&, ByVal 0&)
End If

RegCloseKey lngHandle


If regEnumerate_Key = 0 Then
    strOutKey = Left(OutString, lngRetBuffer)
Else
    strOutKey = vbNullString
End If

End Function
Public Function regEnumerate_Key_Value( _
    lngInRoot As Long, strInKey As String, lngIndex As Long, _
    ByRef strOutValueName As String, ByRef strOutData As String, Optional ByRef lngOutDataType As Long) _
    As Long

Dim lngHandle As Long, useIndex As Long, ValueName As String, DataName As String, ValueBuffer As Long, DataBuffer As Long, DataType As Long
Dim retLong As Long

retLong = RegOpenKeyEx(lngInRoot, strInKey, 0&, _
    KEY_ALL_ACCESS, lngHandle)
If retLong <> 0 Then Exit Function

useIndex = Abs(CLng(lngIndex))
ValueName = Space(255)
ValueBuffer = 255
DataName = Space(255)
DataBuffer = 255

retLong = RegEnumValue(lngHandle, useIndex, ValueName, ValueBuffer, _
    0&, DataType, ByVal DataName, DataBuffer)

If retLong = ERROR_MORE_DATA Then 'dataname string was too short
    DataName = Space(DataBuffer + 1)
    retLong = RegEnumValue(lngHandle, useIndex, ValueName, ValueBuffer, _
        0&, DataType, ByVal DataName, DataBuffer)
End If

RegCloseKey lngHandle

regEnumerate_Key_Value = retLong
strOutValueName = Left(ValueName, ValueBuffer)
strOutData = Left(DataName, DataBuffer - 1)
lngOutDataType = DataType

End Function

Public Function regQuery_A_Key(ByVal lngRootKey As Long, _
                               ByVal strRegKeyPath As String, _
                               ByVal strRegSubKey As String) As Variant
    
' --------------------------------------------------------------
' Written by Kenneth Ives                     kenaso@home.com
'
' Important:     If you treat all key data strings as being
'                case sensitive, you should never have a problem.
'                Always backup your registry files (System.dat
'                and User.dat) before performing any type of
'                modifications
'
' Description:   Function for querying a sub key value.
'
' Parameters:
'           lngRootKey - HKEY_CLASSES_ROOT, HKEY_CURRENT_USER,
'                  HKEY_lOCAL_MACHINE, HKEY_USERS, etc
'    strRegKeyPath - is name of the key path you wish to traverse.
'     strRegSubKey - is the name of the key which will be queryed.
'
' Syntax:
'    strKeyQuery = regQuery_A_Key(HKEY_CURRENT_USER, _
'                       "Software\AAA-Registry Test\Products", _
                        "StringTestData")
'
' Returns the key value of "StringTestData"
' --------------------------------------------------------------
    
' --------------------------------------------------------------
' Define variables
' --------------------------------------------------------------
  Dim intPosition As Integer
  Dim lngKeyHandle As Long
  Dim lngDataType As Long
  Dim lngBufferSize As Long
  Dim lngBuffer As Long
  Dim strBuffer As String

' --------------------------------------------------------------
' Initialize variables
' --------------------------------------------------------------
  lngKeyHandle = 0
  lngBufferSize = 0
  
' --------------------------------------------------------------
' Query the key path
' --------------------------------------------------------------
  m_lngRetVal = RegOpenKey(lngRootKey, strRegKeyPath, lngKeyHandle)
  
' --------------------------------------------------------------
' If no key handle was found then there is no key.  Leave here.
' --------------------------------------------------------------
  If lngKeyHandle = 0 Then
      regQuery_A_Key = ""
      m_lngRetVal = RegCloseKey(lngKeyHandle)   ' always close the handle
      Exit Function
  End If
  
' --------------------------------------------------------------
' Query the registry and determine the data type.
' --------------------------------------------------------------
  m_lngRetVal = RegQueryValueEx(lngKeyHandle, strRegSubKey, 0&, _
                         lngDataType, ByVal 0&, lngBufferSize)
  
' --------------------------------------------------------------
' If no key handle was found then there is no key.  Leave.
' --------------------------------------------------------------
  If lngKeyHandle = 0 Then
      regQuery_A_Key = ""
      m_lngRetVal = RegCloseKey(lngKeyHandle)   ' always close the handle
      Exit Function
  End If
  
' --------------------------------------------------------------
' Make the API call to query the registry based on the type
' of data.
' --------------------------------------------------------------
  Select Case lngDataType
         Case REG_SZ:       ' String data (most common)
              ' Preload the receiving buffer area
              strBuffer = Space(lngBufferSize)
      
              m_lngRetVal = RegQueryValueEx(lngKeyHandle, strRegSubKey, 0&, 0&, _
                                     ByVal strBuffer, lngBufferSize)
              
              ' If NOT a successful call then leave
              If m_lngRetVal <> ERROR_SUCCESS Then
                  regQuery_A_Key = ""
              Else
                  ' Strip out the string data
                  intPosition = InStr(1, strBuffer, Chr(0))  ' look for the first null char
                  If intPosition > 0 Then
                      ' if we found one, then save everything up to that point
                      regQuery_A_Key = Left(strBuffer, intPosition - 1)
                  Else
                      ' did not find one.  Save everything.
                      regQuery_A_Key = strBuffer
                  End If
              End If
              
         Case REG_DWORD:    ' Numeric data (Integer)
              m_lngRetVal = RegQueryValueEx(lngKeyHandle, strRegSubKey, 0&, lngDataType, _
                                     lngBuffer, 4&)  ' 4& = 4-byte word (long integer)
              
              ' If NOT a successful call then leave
              If m_lngRetVal <> ERROR_SUCCESS Then
                  regQuery_A_Key = ""
              Else
                  ' Save the captured data
                  regQuery_A_Key = lngBuffer
              End If
         Case REG_BINARY:    ' binary data
              m_lngRetVal = RegQueryValueEx(lngKeyHandle, strRegSubKey, 0&, lngDataType, _
                                     lngBuffer, lngBufferSize) '
              
              ' If NOT a successful call then leave
              If m_lngRetVal <> ERROR_SUCCESS Then
                  regQuery_A_Key = ""
              Else
                  ' Save the captured data
                  regQuery_A_Key = lngBuffer
              End If
         Stop
         Case Else:    ' unknown
              regQuery_A_Key = ""
  End Select
  
' --------------------------------------------------------------
' Always close the handle in the registry.  We do not want to
' corrupt these files.
' --------------------------------------------------------------
  m_lngRetVal = RegCloseKey(lngKeyHandle)
  
End Function
Public Function regRestoreKey_from_file(lngRoot As Long, ByVal sKeyName As String, ByVal sFileName As String) As Boolean
Dim rrkRet As Long
regRestoreKey_from_file = False
If EnablePrivilege(SE_RESTORE_NAME) = False Then Exit Function
Dim hKey As Long, lRetVal As Long



rrkRet = RegOpenKeyEx(lngRoot, sKeyName, 0&, KEY_ALL_ACCESS, hKey) ' Must open key to restore it
'The file it's restoring from was created using the RegSaveKey function
If rrkRet <> 0 Then


    If Not regDoes_Key_Exist(lngRoot, sKeyName) Then regCreate_A_Key lngRoot, sKeyName

    rrkRet = RegOpenKeyEx(lngRoot, sKeyName, 0&, KEY_ALL_ACCESS, hKey)
    If rrkRet <> 0 Then Exit Function
End If



rrkRet = regRestoreKey(hKey, sFileName, REG_FORCE_RESTORE)
If rrkRet = 0 Then regRestoreKey_from_file = True

RegCloseKey hKey ' Don't want to keep the key open. It causes problems.
End Function
Public Function regSaveKey_to_file(lngRoot As Long, ByVal sKeyName As String, ByVal sFileName As String) As Boolean

Dim rskRet As Long

regSaveKey_to_file = False

If EnablePrivilege(SE_BACKUP_NAME) = False Then Exit Function

Dim hKey As Long, lRetVal As Long

Call RegOpenKeyEx(lngRoot, sKeyName, 0&, KEY_ALL_ACCESS, hKey)   ' Must open key to save it
'Don't forget to "KILL" any existing files before trying to save the registry key!
If hKey <= 0 Then Exit Function

If Dir(sFileName) <> "" Then Kill sFileName
rskRet = regSaveKey(hKey, sFileName, ByVal 0&)
If rskRet = 0 Then regSaveKey_to_file = True

RegCloseKey hKey ' Don't want to keep the key open. It causes problems.

End Function

